% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_edit.R
\name{dictionary_edit}
\alias{dictionary_edit}
\alias{list_edit}
\alias{char_edit}
\title{Conveniently edit dictionaries}
\usage{
dictionary_edit(x, ...)

list_edit(x, ...)

char_edit(x, ...)
}
\arguments{
\item{x}{a \link{dictionary} or (list of) character elements}

\item{...}{(optional) arguments passed to \code{\link[utils:edit]{utils::edit()}} (such as the choice
of editor)}
}
\value{
an edited version of the input object
}
\description{
Provides convenient editing of dictionaries, using an interactive editor.

\code{list_edit()} and \code{char_edit()} provide lower-level convenience functions
for interactive editing of (lists of) character objects.  These can be useful
for instance in editing stopword lists.
}
\examples{
# edit the positive and negative entries from the LSD2015
\dontrun{
my_posneg_dict <- dictionary_edit(data_dictionary_LSD2015[1:2])}

# edit the system stopwords
\dontrun{
my_stopwords <- stopwords("en", source = "snowball") \%>\%
    char_edit()}
}
