% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantities.R
\name{quantities}
\alias{quantities}
\alias{quantities<-}
\alias{set_quantities}
\title{Handle Measurement Units and Uncertainty on a Numeric Vector}
\usage{
quantities(x)

quantities(x) <- value

set_quantities(x, unit, errors = 0, ...,
  mode = units_options("set_units_mode"))
}
\arguments{
\item{x}{a numeric object, or object of class \code{quantities}, \code{units}
or \code{errors}.}

\item{value}{a list of two components: an object of class \code{units} or
\code{symbolic_units} (see \code{\link[units]{units}}), and a numeric vector
of length 1 or the same length as \code{x} (see \code{\link[errors]{errors}}).}

\item{unit}{a \code{units} object, or something coercible to one with
\code{as_units} (see \code{\link[units]{set_units}}).}

\item{errors}{a numeric vector of length 1 or the same length as \code{x}
(see \code{\link[errors:errors]{set_errors}}).}

\item{...}{passed on to \code{as_units}}

\item{mode}{if \code{"symbols"} (the default), then unit is constructed from
the expression supplied. Otherwise, if\code{mode = "standard"},
standard evaluation is used for the supplied value This argument can be set
via a global option \code{units_options(set_units_mode = "standard")}}
}
\description{
Set or retrieve measurement units and uncertainty to/from numeric vectors.
}
\details{
\code{quantities} returns a named list with the \code{units} and
\code{errors} attributes.

\code{`quantities<-`} sets the units and error values (and converts \code{x}
into an object of class \code{quantities}). \code{set_quantities} is a
pipe-friendly version of \code{`quantities<-`} and returns an object of class
\code{quantities}.
}
\examples{
x = 1:3
class(x)
x
quantities(x) <- list("m/s", 0.1)
class(x)
x

(x <- set_quantities(x, m/s, seq(0.1, 0.3, 0.1)))

}
\seealso{
\code{\link{errors}}, \code{\link{units}}, \code{\link{groupGeneric.quantities}}.
\code{\link{Extract.quantities}}, \code{\link{c.quantities}},
\code{\link{rep.quantities}}, \code{\link{cbind.quantities}}.
\code{\link{as.data.frame.quantities}}, \code{\link{as.matrix.quantities}},
\code{\link{t.quantities}}.
}
