% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-BootPos.R
\docType{class}
\name{BootPos-class}
\alias{BootPos}
\alias{BootPos-class}
\title{Class for Generation of Bootstrapped Replications of a Time Series.}
\description{
\code{BootPos} is an S4 class that provides a common interface
to different algorithms that can be used for implementation of a block
bootstrap procedure in the time domain.
}
\details{
After initialization the bootstrapping can be performed by applying
\code{getPositions} to the object.

Different block bootstraps are implemented by creating a subclass together
with a \code{getPositions} method that contains the implementation of the
block resampling procedure.

Currently the following implementations are available:

\itemize{
		\item \code{\link{MovingBlocks}} and \code{\link{getPositions-MovingBlocks}}.
}
}
\section{Slots}{

\describe{
\item{\code{l}}{the (expected) block length for the block bootstrap methods}

\item{\code{N}}{number of available observations to bootstrap from}
}}
\references{
Lahiri, S. N. (1999). Theoretical Comparisons of Block Bootstrap Methods.
\emph{The Annals of Statistics}, \bold{27}(1), 386--404.
}
\keyword{S4-classes}

