% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux-functions.R
\name{timeSeriesValidator}
\alias{timeSeriesValidator}
\title{Validates if \code{Y} is of an appropriate type and converts to a numeric.}
\usage{
timeSeriesValidator(Y)
}
\arguments{
\item{Y}{the time series to be validated.}
}
\value{
Returns the time series as a matrix.
}
\description{
Checks whether \code{Y} is either
\itemize{
  \item \code{numeric},
  \item a \code{ts} object, or
  \item a \code{zoo} object.
}
If not, an error is returned. If it is one of the three the data is returned
as a numeric.
}
\examples{
Y <- timeSeriesValidator(sp500)
Y <- timeSeriesValidator(wheatprices)
Y <- timeSeriesValidator(rnorm(10))
\dontrun{Y <- timeSeriesValidator("Not a valid input")}
}
\keyword{Validator-functions}

