% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{nrow_by}
\alias{nrow_by}
\title{Number of Rows in Data by Group}
\usage{
nrow_by(data, grp.nm, sep = ".")
}
\arguments{
\item{data}{data.frame of data.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
grouping variables.}

\item{sep}{character vector of length 1 specifying what string to use to
separate the groups when naming the return object. \code{sep} is only used
if \code{grp.nm} has length > 1 (aka multiple grouping variables)}
}
\value{
atomic vector with names = \code{unique(interaction(data[grp.nm], sep
  = sep))} and length = \code{length(unique(interaction(data[grp.nm], sep =
  sep)))} providing the nrow for each group.
}
\description{
\code{nrow_by} computes the nrow of a data.frame by group. \code{nrow_by} is
simply a wrapper for \code{nrow} + \code{agg_dfm}.
}
\examples{

# one grouping variables
tmp_nm <- c("outcome","case","session","trt_time")
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp_nm]
stats_by <- psych::statsBy(dat,
   group = "case") # requires you to include "case" column in dat
nrow_by(data = dat, grp.nm = "case")
dat2 <- as.data.frame(ChickWeight)
nrow_by(data = dat2, grp.nm = "Chick")

# two grouping variables
tmp <- reshape(psych::bfi[1:10, ], varying = 1:25, timevar = "item",
   ids = row.names(psych::bfi)[1:10], direction = "long", sep = "")
tmp_nm <- c("id","item","N","E","C","A","O") # Roxygen runs the whole script
dat3 <- str2str::stack2(tmp[tmp_nm], select.nm = c("N","E","C","A","O"),
   keep.nm = c("id","item"))
nrow_by(dat3, grp.nm = c("id","vrb_names"))

}
\seealso{
\code{\link{ncases_by}}
   \code{\link{nrow}}
   \code{\link{agg_dfm}}
}
