% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.server.stepfun}
\alias{as.server.stepfun}
\title{Create a \code{server.stepfun} object with a roster of times and number of available servers.}
\usage{
as.server.stepfun(x, y)
}
\arguments{
\item{x}{numeric vector giving the times of changes in number of servers.}

\item{y}{numeric vector one longer than \code{x} giving the number of servers
available between x values.}
}
\value{
A \code{list} and \code{server.stepfun} object with x and y as elements.
}
\description{
Create a \code{server.stepfun} object with a roster of times and number of available servers.
}
\details{
This function uses the analogy of a step function to specify the number of
available servers throughout the day. It is used as input to the \code{\link{queue_step}}
function. Alternativily one may use \code{as.server.list} to specify available servers as
a list, however \code{queue_step} is much faster when \code{as.server.stepfun} is used
as input rather than \code{as.server.list}.

If any of the service times are large compared to any element of \code{diff(x)} then the
\code{\link{as.server.list}} function should be used.
}
\examples{

servers <- as.server.stepfun(c(15,30,50), c(0, 1, 3, 2))
servers

}
\seealso{
\code{\link{as.server.list}}, \code{\link{queue_step}}, \code{\link{stepfun}}.
}
