% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_analysis.R
\name{print.summary_queue_list}
\alias{print.summary_queue_list}
\title{Print method for output of \code{summary.queue_list}.}
\usage{
\method{print}{summary_queue_list}(x, ...)
}
\arguments{
\item{x}{an object of class \code{summary_queue_list}, the result of a call to \code{summary.queue_list()}.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
A list of performance statistics for the queue:

"Total customers": Total customers in simulation,

"Missed customers": Customers who never saw a server,

"Mean waiting time": The mean time each customer had to wait in queue for service,

"Mean response time": The mean time that each customer spends in the system (departure time - arrival time),

"Utilization factor": The ratio of available time for all servers and time all servers were used. It can be greater than one if a customer arrives near the end of a shift and keeps a server busy,

"Mean queue length": Average queue length, and

"Mean number of customers in system": Average number of customers in queue or currently being served.
}
\description{
Print method for output of \code{summary.queue_list}.
}
\examples{
n <- 1e3
arrivals <- cumsum(rexp(n, 1.8))
service <- rexp(n)

queue_obj <- queue_step(arrivals, service, servers = 2)
summary(queue_obj)
}
