% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hms.R
\name{hms_}
\alias{hms_}
\alias{hms_bounded}
\alias{hms_left_bounded}
\alias{hms_right_bounded}
\title{hms generators}
\usage{
hms_(len = 1L, frac_na = 0)

hms_bounded(left, right, len = 1L, frac_na = 0)

hms_left_bounded(left, len = 1L, frac_na = 0)

hms_right_bounded(right, len = 1L, frac_na = 0)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10.}

\item{frac_na}{The approximate fraction of \code{NA} values to
be included in the vector. A fraction of 0, the default,
will include no \code{NA} values. A fraction of 0.5 would
include around 50\% \code{NA} values.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{hedgehog.internal.gen} generator
}
\description{
A set of generators for hms vectors.
}
\examples{
hms_() |> show_example()
hms_bounded(
  left = hms::as_hms("00:00:00"),
  right = hms::as_hms("12:00:00")
) |> show_example()
hms_(len = 10L, frac_na = 0.5) |> show_example()
}
