% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/any.R
\name{any_tibble}
\alias{any_tibble}
\title{Any tibble generator}
\usage{
any_tibble(rows = c(1L, 10L), cols = c(1L, 10L), any_na = FALSE)
}
\arguments{
\item{rows}{Number of rows of the generated data frame.
If \code{rows} is a single number all data frames will have
this number of rows. If \code{rows} is a numeric vector of
length 2 it will produce data frames with rows between
a minimum and maximum, inclusive. For example
\code{rows = c(1L, 10L)} would produce data frames with rows
between 1 and 10. To produce empty tibbles set \code{rows = 0L}
or a range like \code{rows = c(0L, 10L)}.}

\item{cols}{Number of columns of the generated data frame.
If \code{cols} is a single number all data frames will have
this number of columns. If \code{cols} is a numeric vector
of length 2 it will produce data frames with columns
between a minimum and maximum, inclusive. For example
\code{cols = c(1L, 10L)} would produce data frames with
columns between 1 and 10. To produce empty tibbles
set \code{cols = 0L} or a range like \code{cols = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
Generate tibbles.
}
\examples{
any_tibble(rows = 3L, cols = 3L) \%>\% show_example()
}
