% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{getGitRepoStart}
\alias{getGitRepoStart}
\alias{getGitRepoChange}
\title{Fetch GitHub Repository Creation & Last Updated Date}
\usage{
getGitRepoStart(repo_name, out.format = "\%Y-\%m-\%d")

getGitRepoChange(repo_name, out.format = "\%Y-\%m-\%d")
}
\arguments{
\item{repo_name}{name of the repository}

\item{out.format}{date output format}
}
\value{
date of creation of repository as a character

date of the last update of repository as a character
}
\description{
The GitHub REST API is a powerful tool that allows developers
to interact with GitHub programmatically. It provides a set of
endpoints that allows a user to create integration, retrieve data,
and automate workflows related to GitHub repositories. It is a means
by which users can interact with GitHub without directly using a web interface.
}
\details{
The two functions utilize the GitHub REST API to extract important temporal information about a GitHub repository. \cr\cr
 - the getGitRepoStart function is used to retrieve the date a GitHub repository was first created.\cr\cr
 - the getGitRepoChange function retrieves the date a GitHub repository was last updated.
}
\examples{
\donttest{
# Use default date format
getGitRepoStart(repo_name = "oobianom/quickcode")

# Specify date format
getGitRepoStart(repo_name = "oobianom/quickcode", out.format = "\%j|\%Y")
getGitRepoStart(repo_name = "oobianom/quickcode", out.format = "\%D|\%j")
}

\donttest{
getGitRepoChange(repo_name = "oobianom/shinyStorePlus", out.format = "\%d-\%b-\%Y")
getGitRepoChange(repo_name = "oobianom/r2social", out.format = "\%Y/\%m/\%d")
}

}
