% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame_bayes.R
\name{frame_bayes}
\alias{frame_bayes}
\title{Mean probability of posterior distribution and
Kullback-Leibler divergence for observations in Bayesian
quantile regression model}
\usage{
frame_bayes(y, x, tau, M, burn, method = c("bayes.prob", "bayes.kl"))
}
\arguments{
\item{y}{vector, dependent variable in quantile regression}

\item{x}{matrix, design matrix for quantile regression. For quantile regression
model with intercept, the firt column of x is 1.}

\item{tau}{sigular or vector, quantiles}

\item{M}{the iteration frequancy for MCMC used in Baysian estimation}

\item{burn}{burned MCMC draw}

\item{method}{the diagnostic method for outlier detection}
}
\value{
Mean probability or Kullback-Leibler divergence for observations
in Bayesian quantile regression model
}
\description{
This function give the dataframe to plot the mean
probability of posterior and Kullback-leibler divergence
of quantile regression model with asymmetric laplace
distribution based on bayes estimation procedure.
}
\examples{
\dontrun{
library(ggplot2)
ais_female <- subset(ais, Sex == 1)
y <- ais_female$BMI
x <- matrix(ais_female$LBM, 1)
tau <- c(0.1, 0.5, 0.9)
case <- rep(1:length(y), length(tau))
prob <- frame_bayes(y, x, tau, M =  5000, burn = 1000,
                 method = 'bayes.prob')
prob_m <- cbind(case, prob)
ggplot(prob_m, aes(x = case, y = value )) +
  geom_point() +
  geom_text(aes(label = case)) +
  facet_wrap(~variable, scale = 'free') +
  xlab("case number") +
  ylab("Mean probability of posterior distribution")
It takes time to run the following code.
kl <- frame_bayes(y, x, tau, M = 50, burn = 10,
                method = 'bayes.kl')
kl_m <- cbind(case, kl)
ggplot(kl_m, aes(x = case, y = value)) +
  geom_point() +
  geom_text(aes(label = case)) +
  facet_wrap(~variable, scale = 'free')+
  xlab('case number') +
  ylab('Kullback-Leibler')
}

}
\author{
Wenjing Wang \email{wenjingwangr@gmail.com}
}
