% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ll.R
\name{ll}
\alias{ll}
\title{List Object Aliases}
\usage{
ll(pos = 1, pattern, order_by = "Size", decreasing = TRUE, head = FALSE, n = 5)
}
\arguments{
\item{pos}{specifies the environment as a position in the search list}

\item{pattern}{an optional regular expression.  Only names matching
\code{pattern} are returned.  \code{\link[utils]{glob2rx}} can be used to
convert wildcard patterns to regular expressions.}

\item{order_by}{a character, order the results by \dQuote{Size} (default),
\dQuote{Type}, \dQuote{Rows}, or \dQuote{Columns}.}

\item{decreasing}{logical, defaults to \code{TRUE}, decreasing order? passed
to \code{\link[base]{order}}.}

\item{head}{logical, if \code{TRUE} then only return the first \code{n}
objects per \code{order_by} and \code{decreasing}.}

\item{n}{number of rows to return, ignored if \code{head = FALSE}.}
}
\description{
Aliases for \code{\link[base]{ls}} providing additional details.
}
\examples{
# View your current workspace
\dontrun{
ls()
ll()
}

# View another environment
e <- new.env()
e$fit <- lm(mpg ~ wt, mtcars)
e$fit2 <- lm(mpg ~ wt + am + vs, data = mtcars)
e$x <- rnorm(1e5)
e$y <- runif(1e4)
e$z <- with(e, x * y)
e$w <- sum(e$z)
ls(e)
ll(e)
ll(e, head = TRUE)

}
\references{
The basis for this work came from a Stack Overflow posting:
\url{http://stackoverflow.com/questions/1358003/tricks-to-manage-the-available-memory-in-an-r-session}
}
\seealso{
\code{\link[base]{ls}}
}
