% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lapply.R
\docType{data}
\name{callingCodeOf}
\alias{callingCodeOf}
\title{Fetch the calling code of a country}
\format{
An object of class \code{list} of length 193.
}
\usage{
callingCodeOf
}
\value{
a list containing all countries and their corresponding calling code
}
\description{
With specified country name or names, get the associated calling code
}
\examples{
# view the searchable countries, return first 6
head(names(callingCodeOf))

#task 0: check if the calling code of japan is included
#should be all in lower case
grep("japan",names(callingCodeOf), value = TRUE)

#task 1: check the calling code of nigeria
callingCodeOf$nigeria

#task 2: check the calling code of united states
callingCodeOf$`united states`


#task 3: check calling code of multiple countries
callingCodeOf[c("slovenia","romania","malaysia")]

#task 4: what if the calling code is not available
callingCodeOf[c("randomcountry","mexico","luxembourg")]

}
\keyword{datasets}
