% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{html_dependencies_d3}
\alias{html_dependencies_d3}
\title{D3 HTML dependencies}
\usage{
html_dependencies_d3(version = c("5", "4", "3"), extensions = NULL)
}
\arguments{
\item{version}{Major version of D3}

\item{extensions}{D3 extensions to include. Currently the only supported
extension is "jetpack" (\url{https://github.com/gka/d3-jetpack}).}
}
\description{
Create HTML dependencies for D3 and optional extensions
}
\details{
Create list of HTML dependencies for D3. Each version has
a distinct root D3 object so it's possible to combine multiple versions
of D3 on a single page. For example, D3 v5 is accessed via \code{d3v5} and
D3 v4 is accessed via \code{d3v4}. Note however that D3 v3 is accessed via
simply \code{d3} (for compabibilty with existing htmlwidgets that use
this form).
}
\note{
This function is exported for use by htmlwidgets. If you are
using the \code{r2d3()} function to include D3 code within a document
or application this dependency is included automatically so calling
this function is unnecessary.
}
\examples{

library(r2d3)
r2d3(
  data = c (0.3, 0.6, 0.8, 0.95, 0.40, 0.20),
  script = system.file("examples/barchart.js", package = "r2d3"),
  dependencies = "d3-jetpack"
)

}
