% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_r2dii.R
\name{scale_colour_r2dii}
\alias{scale_colour_r2dii}
\alias{scale_color_r2dii}
\alias{scale_fill_r2dii}
\title{Custom 2DII colour and fill scales}
\usage{
scale_colour_r2dii(labels = NULL, ...)

scale_fill_r2dii(labels = NULL, ...)
}
\arguments{
\item{labels}{A character vector. Specifies colour labels to use and their
order. Run \code{unique(r2dii.plot:::palette_colours$label)} to see available
labels. Similar to \code{value} parameter in \code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}}.}

\item{...}{Other parameters passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\value{
An object of class "ScaleDiscrete".
}
\description{
A custom discrete colour and fill scales with colours from 2DII palette.
}
\examples{
library(ggplot2, warn.conflicts = FALSE)

ggplot(mpg) +
  geom_point(aes(displ, hwy, color = class)) +
  scale_colour_r2dii()

ggplot(mpg) +
  geom_histogram(aes(cyl, fill = class), position = "dodge", bins = 5) +
  scale_fill_r2dii()
}
\seealso{
Other r2dii scales: 
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()}
}
\concept{r2dii scales}
