% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{decorate.glmnet}
\alias{decorate.glmnet}
\title{Decorates a "glmnet" object with a "lambda.s" element.}
\usage{
\method{decorate}{glmnet}(x, lambda.s, ...)
}
\arguments{
\item{x}{A "glmnet" object.}

\item{lambda.s}{The best lambda value. Must be one of listed "glmnet$lambda" values.}

\item{...}{Arguments to pass on to the "decorate.default" function.}
}
\description{
Decorates a "glmnet" object with a "lambda.s" element.
}
\examples{
\donttest{
library("glmnet")
library("r2pmml")

data(iris)
iris_x = as.matrix(iris[, -ncol(iris)])
iris_y = iris[, ncol(iris)]
iris.glmnet = glmnet(x = iris_x, y = iris_y, family = "multinomial")
iris.glmnet = decorate(iris.glmnet, lambda.s = iris.glmnet$lambda[49])
r2pmml(iris.glmnet, file.path(tempdir(), "Iris-GLMNet.pmml"))
}
}
