/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.converter.visitors.ActiveFieldFinder;
import org.jpmml.converter.visitors.FieldDependencyResolver;
import org.jpmml.converter.visitors.FieldUtil;

public class DataDictionaryCleaner
extends ActiveFieldFinder {
    private Set<Field<?>> nonActiveFields = new LinkedHashSet();

    @Override
    public void reset() {
        super.reset();
        this.nonActiveFields.clear();
    }

    @Override
    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            Model model = (Model)parent;
            this.processModel(model);
        } else if (parent instanceof PMML) {
            PMML pmml = (PMML)parent;
            DataDictionary dataDictionary = pmml.requireDataDictionary();
            this.processDataDictionary(dataDictionary);
        }
        return parent;
    }

    private void processModel(Model model) {
        Set<Field<?>> nonActiveFields = this.getNonActiveFields();
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
            List miningFields = miningSchema.getMiningFields();
            block3: for (MiningField miningField : miningFields) {
                String fieldName = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case ACTIVE: {
                        continue block3;
                    }
                }
                fieldNames.add(fieldName);
            }
            if (!fieldNames.isEmpty()) {
                Collection modelFields = this.getFields(new PMMLObject[]{model});
                nonActiveFields.addAll(FieldUtil.selectAll(modelFields, fieldNames));
            }
        }
    }

    private void processDataDictionary(DataDictionary dataDictionary) {
        if (dataDictionary.hasDataFields()) {
            List dataFields = dataDictionary.getDataFields();
            Set<DataField> referencedDataFields = this.getReferencedDataFields();
            dataFields.retainAll(referencedDataFields);
        }
    }

    private Set<DataField> getReferencedDataFields() {
        FieldDependencyResolver fieldDependencyResolver = this.getFieldDependencyResolver();
        HashSet fields = new HashSet(this.getActiveFields());
        fields.addAll(this.getNonActiveFields());
        fieldDependencyResolver.expand(fields, fieldDependencyResolver.getLocalDerivedFields());
        fieldDependencyResolver.expand(fields, fieldDependencyResolver.getGlobalDerivedFields());
        return fields;
    }

    private Set<Field<?>> getNonActiveFields() {
        return this.nonActiveFields;
    }
}

