/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ResultField", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="ResultField")
@JsonPropertyOrder(value={"name", "displayName", "opType", "dataType", "resultFeature", "value", "extensions"})
public class ResultField
extends Field<ResultField>
implements HasExtensions<ResultField> {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="name")
    private String name;
    @XmlAttribute(name="displayName")
    @JsonProperty(value="displayName")
    private String displayName;
    @XmlAttribute(name="optype")
    @JsonProperty(value="optype")
    private OpType opType;
    @XmlAttribute(name="dataType")
    @JsonProperty(value="dataType")
    private DataType dataType;
    @XmlAttribute(name="feature")
    @JsonProperty(value="feature")
    private ResultFeature resultFeature;
    @XmlAttribute(name="value")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="value")
    private Object value;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371270L;

    public ResultField() {
    }

    @ValueConstructor
    public ResultField(@Property(value="name") String name) {
        this.name = name;
    }

    @Override
    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.RESULTFIELD_NAME);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResultField setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ResultField setDisplayName(@Property(value="displayName") String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType requireOpType() {
        if (this.opType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.RESULTFIELD_OPTYPE);
        }
        return this.opType;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    @Override
    public ResultField setOpType(@Property(value="opType") OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType requireDataType() {
        if (this.dataType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.RESULTFIELD_DATATYPE);
        }
        return this.dataType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public ResultField setDataType(@Property(value="dataType") DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public ResultFeature getResultFeature() {
        return this.resultFeature;
    }

    public ResultField setResultFeature(@Property(value="resultFeature") ResultFeature resultFeature) {
        this.resultFeature = resultFeature;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public ResultField setValue(@Property(value="value") Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ResultField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

