% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_read_png.R
\name{rtf_read_png}
\alias{rtf_read_png}
\title{Read PNG Figures into Binary Files}
\usage{
rtf_read_png(file)
}
\arguments{
\item{file}{A character vector of PNG file paths.}
}
\value{
a list of binary data vector returned by \code{readBin}
}
\description{
Read PNG Figures into Binary Files
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Read PNG figures into binary file using \code{lapply} and \code{readBin}
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
\dontrun{
file <- file.path(tempdir(), "figure1.png")
png(file)
plot(1:10)
dev.off()

# Read in PNG file in binary format
rtf_read_png(file)
}

}
