% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_rtf_table.R
\name{as_rtf_table}
\alias{as_rtf_table}
\title{Combine RTF Table Encoding}
\usage{
as_rtf_table(tbl)
}
\arguments{
\item{tbl}{A data frame.}
}
\description{
Combine RTF Table Encoding
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Calculate number of rows for table content, title, header, footnote and source for each page from `tbl` object.
   \item Calculate number of pages using total number of rows divided by number of rows in each page.
   \item Extract first and last row for each page, assign border type and color attributes based on input from `rtf_body()`.
   \item Convert to RTF encoding using `rtf_table_content()`.
   \item Combine all components into a single code string.
   \item Add info attributes into `tbl`.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

