% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{tTest}
\alias{tTest}
\alias{print.tTestSPSS}
\title{t Tests}
\usage{
tTest(data, variables, group = NULL, mu = 0, conf.level = 0.95)

\method{print}{tTestSPSS}(x, digits = 3, statistics = c("statistics", "test"), ...)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying numeric variable(s) to be
used for testing the mean(s).  If \code{group} is \code{NULL}, a one-sample
t test is performed if only one variable is specified, and a paired-sample
t test is performed if two variables are specified.  If a grouping variable
is specified in \code{group}, an independent-samples t-test is performed and
this should be a character string specifying the numeric variable of
interest.}

\item{group}{a character string specifying a grouping variable for an
independent-samples t-test, or \code{NULL}.}

\item{mu}{a number indicating the true value of the mean for a one-sample
t test.}

\item{conf.level}{a number between 0 and 1 giving the confidence level of
the confidence interval.}

\item{x}{an object of class \code{"tTestSPSS"} as returned by function
\code{tTest}.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the LaTeX tables.}

\item{statistics}{a character vector specifying which LaTeX tables should
be printed.  Available options are \code{"statistics"} for descriptive
statistics and \code{"test"} for test results.  The default is to print both
tables.}

\item{\dots}{currently ignored.}
}
\value{
An object of class \code{"tTestSPSS"} with the following
components:
\describe{
  \item{\code{statistics}}{a data frame containing the relevant descriptive
  statistics.}
  \item{\code{test}}{an object of class \code{"htest"} as returned by
  \code{\link[stats]{t.test}} (only one-sample and paired-sample tests).}
  \item{\code{variables}}{a character vector containing the name(s) of the
  relevant numeric variable(s).}
  \item{\code{n}}{an integer giving the number of observations (only
  paired-sample test).}
  \item{\code{levene}}{an object as returned by
  \code{\link[car]{leveneTest}} (only independent-samples test).}
  \item{\code{pooled}}{an object of class \code{"htest"} as returned
  by \code{\link[stats]{t.test}} assuming equal variances (only
  independent-samples test).}
  \item{\code{satterthwaite}}{an object of class \code{"htest"} as returned
  by \code{\link[stats]{t.test}} not assuming equal variance (only
  independent-samples test).}
  \item{\code{group}}{a character string containing the name of the
  grouping variable (only independent-samples test).}
  \item{\code{type}}{a character string giving the type of t test performed
  (\code{"one-sample"}, \code{"paired"}, or \code{"independent"}).}
}

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output (version <24).
}
\description{
Perform a one-sample t test, a paired-sample t test or an
independent-samples t test on variables of a data set.  The output
is printed as a LaTeX table that mimics the look of SPSS output
(version <24).
}
\examples{
## one-sample and paired-sample t test

# load data
data("Exams")

# test whether the average grade on the resit
# differs from 5.5 (minimum passing grade)
tTest(Exams, "Resit", mu = 5.5)

# test whether average grades differ between the
# regular exam and the resit
tTest(Exams, c("Resit", "Regular"))


## independent-samples t test

# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# test whether average log market values differ between
# Dutch and foreign players
tTest(Eredivisie, "logMarketValue", group = "Foreign")

}
\author{
Andreas Alfons
}
\keyword{htest}
