% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{t_test}
\alias{t_test}
\alias{to_SPSS.t_test_SPSS}
\alias{print.t_test_SPSS}
\alias{tTest}
\title{t Tests}
\usage{
t_test(data, variables, group = NULL, mu = 0, conf.level = 0.95)

\method{to_SPSS}{t_test_SPSS}(
  object,
  statistics = c("test", "statistics"),
  version = r2spss_options$get("version"),
  digits = 3,
  ...
)

\method{print}{t_test_SPSS}(
  x,
  statistics = c("statistics", "test"),
  version = r2spss_options$get("version"),
  digits = 3,
  ...
)

tTest(data, variables, group = NULL, mu = 0, conf.level = 0.95)
}
\arguments{
\item{data}{a data frame containing the variables.}

\item{variables}{a character vector specifying numeric variable(s) to be
used for testing the mean(s).  If \code{group} is \code{NULL}, a one-sample
t test is performed if only one variable is specified, and a paired-sample
t test is performed if two variables are specified.  If a grouping variable
is specified in \code{group}, an independent-samples t-test is performed and
this should be a character string specifying the numeric variable of
interest.}

\item{group}{a character string specifying a grouping variable for an
independent-samples t-test, or \code{NULL}.}

\item{mu}{a number indicating the true value of the mean for a one-sample
t test.}

\item{conf.level}{a number between 0 and 1 giving the confidence level of
the confidence interval.}

\item{object, x}{an object of class \code{"t_test_SPSS"} as returned by
function \code{t_test}.}

\item{statistics}{a character string or vector specifying which SPSS tables
to produce.  Available options are \code{"statistics"} for descriptive
statistics and \code{"test"} for test results.  For the \code{to_SPSS}
method, only one option is allowed (the default is the table of test
results), but the \code{print} method allows several options (the default
is to print all tables).}

\item{version}{a character string specifying whether the table should
mimic the content and look of recent SPSS versions (\code{"modern"}) or
older versions (<24; \code{"legacy"}).  The main differences in terms of
content are that recent SPSS versions show a one-sided p-value in addition
to the two-sided p-value, and that small p-values are displayed differently.
For the paired-sample test, recent versions of SPSS also display a label
\emph{Pair 1} for the selected pair of variables.}

\item{digits}{an integer giving the number of digits after the comma to be
printed in the SPSS tables.}

\item{\dots}{additional arguments to be passed down to
\code{\link{format_SPSS}}.}
}
\value{
An object of class \code{"t_test_SPSS"} with the following
components:
\describe{
  \item{\code{statistics}}{a data frame containing the relevant descriptive
  statistics.}
  \item{\code{test}}{an object of class \code{"htest"} as returned by
  \code{\link[stats]{t.test}} (only one-sample and paired-sample tests).}
  \item{\code{variables}}{a character vector containing the name(s) of the
  relevant numeric variable(s).}
  \item{\code{n}}{an integer giving the number of observations (only
  paired-sample test).}
  \item{\code{levene}}{an object as returned by
  \code{\link[car]{leveneTest}} (only independent-samples test).}
  \item{\code{pooled}}{an object of class \code{"htest"} as returned
  by \code{\link[stats]{t.test}} assuming equal variances (only
  independent-samples test).}
  \item{\code{satterthwaite}}{an object of class \code{"htest"} as returned
  by \code{\link[stats]{t.test}} not assuming equal variance (only
  independent-samples test).}
  \item{\code{group}}{a character string containing the name of the
  grouping variable (only independent-samples test).}
  \item{\code{type}}{a character string giving the type of t test performed
  (\code{"one-sample"}, \code{"paired"}, or \code{"independent"}).}
}

The \code{to_SPSS} method returns an object of class \code{"SPSS_table"}
which contains all relevant information in the required format to produce
the LaTeX table.  See \code{\link{to_latex}} for possible components and
how to further customize the LaTeX table based on the returned object.

The \code{print} method produces a LaTeX table that mimics the look of SPSS
output.
}
\description{
Perform a one-sample t test, a paired-sample t test or an
independent-samples t test on variables of a data set.  The output
is printed as a LaTeX table that mimics the look of SPSS output.
}
\details{
The \code{print} method first calls the \code{to_SPSS} method followed
by \code{\link{to_latex}}.  Further customization can be done by calling
those two functions separately, and modifying the object returned by
\code{to_SPSS}.
}
\note{
LaTeX tables that mimic recent versions of SPSS (\code{version = "modern"})
may require several LaTeX compilations to be displayed correctly.
}
\examples{
## one-sample and paired-sample t test

# load data
data("Exams")

# test whether the average grade on the resit
# differs from 5.5 (minimum passing grade)
t_test(Exams, "Resit", mu = 5.5)

# test whether average grades differ between the
# regular exam and the resit
t_test(Exams, c("Resit", "Regular"))


## independent-samples t test

# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# test whether average log market values differ between
# Dutch and foreign players
t_test(Eredivisie, "logMarketValue", group = "Foreign")

}
\author{
Andreas Alfons
}
\keyword{htest}
