% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{m_style_sphere}
\alias{m_style_sphere}
\title{Specify Styling for Sphere}
\usage{
m_style_sphere(
  hidden = FALSE,
  radius = 1,
  scale = 1,
  colorScheme = "default",
  color = NULL,
  opacity = 1
)
}
\arguments{
\item{hidden}{Boolean - do not show atom. Default \code{FALSE}.}

\item{radius}{Override van der waals radius.}

\item{scale}{Scale radius by specified amount.}

\item{colorScheme}{Specify scheme to color the atoms by. Default is
"default". Other choies are "Carbon", ssPyMOL", "ssJmol", "Jmol",
"default", "amino",
"shapely", "nucleic", "chain", "chainHetatm", "prop".}

\item{color}{Discrete, fixed coloring, overrides any colorScheme.}

\item{opacity}{Opacity of spheres, 0 being invisible. Must be the same for
all atoms in the model.}
}
\description{
Styling options for the sphere representation. Used inside
\code{m_add_style()} and \code{m_set_style()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = m_style_sphere(radius = 0.5)) \%>\%
  m_zoom_to()
}
