% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSaxes.R
\name{axis3js}
\alias{axis3js}
\title{Add an axis to an r3js plot}
\usage{
axis3js(
  data3js,
  side,
  at = NULL,
  labels = NULL,
  cornerside = "f",
  labeloffset = 0.1,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{side}{The axis side, either "x", "y" or "z"}

\item{at}{Where to draw labels}

\item{labels}{Vector of labels to use}

\item{cornerside}{See \code{material3js()}}

\item{labeloffset}{Amount of offset of axis labels from the edge of the plot}

\item{...}{Other arguments to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
This is used as part of the \code{plot3js()} function but can be called
separately to add an axis, generally in combination after other lower
level functions like \code{plot3js.new()} and \code{plot3js.window()}.
}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
