% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSlines.R
\name{lines3js}
\alias{lines3js}
\title{Add lines to a data3js object}
\usage{
lines3js(
  data3js,
  x,
  y,
  z,
  lwd = 1,
  col = "black",
  highlight,
  geometry = FALSE,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{x}{x coordinates}

\item{y}{y coordinates}

\item{z}{z coordinates}

\item{lwd}{line width}

\item{col}{line color (only a single color is currently supported)}

\item{highlight}{highlight characteristics (see \code{highlight3ks()})}

\item{geometry}{logical, should the point be rendered as a physical geometry}

\item{...}{further parameters to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
This adds lines to a plot, similarly to the \code{lines()} function. You have to decide whether
you would like lines to physically exist as geometries in the scene (geometry = TRUE), i.e. as
cylinders, or rather as webgl lines draw into the scene (geometry = FALSE). Such lines added will
be "non-geometric" in the sense that they do not physically exist in the scene, so will not be
shaded according to lighting, and their width will remain constant independent of how the plot
is zoomed. As with \code{points3js(geometry = FALSE)} lines drawn in this way are rendered much more
efficiently and sometimes the fixed width characteristic is desirable, for example grid lines
are drawn in this way.
}
\examples{
# Draw three lines
x <- seq(from = 0, to = 6, length.out = 100)
y <- cos(x*5)
z <- sin(x*5)
linecols <- rainbow(100)

p <- plot3js(
  xlim = c(0, 6),
  ylim = c(0, 6),
  zlim = c(-1, 1),
  aspect = c(1, 1, 1),
  label_axes = FALSE
)

# Add a line using the linegl representation
p <- lines3js(
  data3js = p,
  x, y + 1, z,
  col = linecols
)

# Add a thicker line using the linegl representation
p <- lines3js(
  data3js = p,
  x, y + 3, z,
  lwd = 3,
  col = linecols
)

# Add a line as a physical geometry to the plot
p <- lines3js(
  data3js = p,
  x, y + 5, z,
  lwd = 0.2,
  geometry = TRUE,
  col = "blue" # Currently only supports fixed colors
)

# View the plot
r3js(p, rotation = c(0, 0, 0), zoom = 2)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
