% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_r5.R
\name{setup_r5}
\alias{setup_r5}
\title{Create transport network used for routing in R5}
\usage{
setup_r5(data_path, version = "4.9.0", verbose = TRUE, temp_dir = FALSE)
}
\arguments{
\item{data_path}{character string, the directory where data inputs are stored
and where the built network.dat will be saved.}

\item{version}{character string, the version of R5 to be used. Defaults to
latest version '4.9.0'.}

\item{verbose}{logical, TRUE to show detailed output messages (Default) or
FALSE to show only eventual ERROR and WARNING messages.}

\item{temp_dir}{logical, whether the R5 Jar file should be saved in temporary
directory. Defaults to FALSE}
}
\value{
An rJava object to connect with R5 routing engine
}
\description{
Combine data inputs in a directory to build a multimodal
transport network used for routing in R5. The directory must contain at
least one street network file (in .pbf format). One or more public transport
data sets (in GTFS.zip format) are optional. If there is more than one GTFS file
in the directory, both files will be merged. If there is already a 'network.dat'
file in the directory the function will simply read it and load it to memory.
}
\examples{
\dontrun{

library(r5r)

# directory with street network and gtfs files
path <- system.file("extdata/poa", package = "r5r")

r5r_core <- setup_r5(data_path = path, temp_dir = TRUE)
}
}
\seealso{
Other setup: 
\code{\link{download_r5}()}
}
\concept{setup}
