/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringJoiner;

public class RDataFrame {
    private int rowCount = 0;
    private final int capacity;
    private final LinkedHashMap<String, ArrayList<Object>> dataFrame;
    private final LinkedHashMap<String, Object> defaultValues;
    private final ArrayList<String> columnNames;
    private final ArrayList<String> columnTypes;

    public LinkedHashMap<String, ArrayList<Object>> getDataFrame() {
        return this.dataFrame;
    }

    public int nRow() {
        return this.rowCount;
    }

    public void updateRowCount() {
        if (this.columnNames.size() > 0) {
            this.rowCount = this.dataFrame.get(this.columnNames.get(0)).size();
        }
    }

    public RDataFrame() {
        this(10);
    }

    public RDataFrame(int capacity) {
        this.capacity = capacity;
        this.dataFrame = new LinkedHashMap();
        this.defaultValues = new LinkedHashMap();
        this.columnNames = new ArrayList();
        this.columnTypes = new ArrayList();
    }

    public void append() {
        this.dataFrame.forEach((columnName, columnContents) -> {
            Object defaultValue = this.defaultValues.get(columnName);
            columnContents.add(defaultValue);
        });
        ++this.rowCount;
    }

    public void set(String columnName, String value) {
        List column = this.dataFrame.get(columnName);
        column.set(column.size() - 1, value);
    }

    public void set(String columnName, Boolean value) {
        List column = this.dataFrame.get(columnName);
        column.set(column.size() - 1, value);
    }

    public void set(String columnName, Integer value) {
        List column = this.dataFrame.get(columnName);
        column.set(column.size() - 1, value);
    }

    public void set(String columnName, Long value) {
        List column = this.dataFrame.get(columnName);
        column.set(column.size() - 1, value);
    }

    public void set(String columnName, Double value) {
        List column = this.dataFrame.get(columnName);
        column.set(column.size() - 1, value);
    }

    public void addStringColumn(String columnName, String defaultValue) {
        ArrayList<String> column = new ArrayList<String>(this.capacity);
        for (int i = 0; i < this.nRow(); ++i) {
            column.add(defaultValue);
        }
        this.dataFrame.put(columnName, column);
        this.defaultValues.put(columnName, defaultValue);
        this.columnNames.add(columnName);
        this.columnTypes.add("String");
    }

    public void addBooleanColumn(String columnName, Boolean defaultValue) {
        ArrayList<Boolean> column = new ArrayList<Boolean>(this.capacity);
        for (int i = 0; i < this.nRow(); ++i) {
            column.add(defaultValue);
        }
        this.dataFrame.put(columnName, column);
        this.defaultValues.put(columnName, defaultValue);
        this.columnNames.add(columnName);
        this.columnTypes.add("Boolean");
    }

    public void addIntegerColumn(String columnName, Integer defaultValue) {
        ArrayList<Integer> column = new ArrayList<Integer>(this.capacity);
        for (int i = 0; i < this.rowCount; ++i) {
            column.add(defaultValue);
        }
        this.dataFrame.put(columnName, column);
        this.defaultValues.put(columnName, defaultValue);
        this.columnNames.add(columnName);
        this.columnTypes.add("Integer");
    }

    public void addLongColumn(String columnName, Long defaultValue) {
        ArrayList<Long> column = new ArrayList<Long>(this.capacity);
        for (int i = 0; i < this.rowCount; ++i) {
            column.add(defaultValue);
        }
        this.dataFrame.put(columnName, column);
        this.defaultValues.put(columnName, defaultValue);
        this.columnNames.add(columnName);
        this.columnTypes.add("Long");
    }

    public void addDoubleColumn(String columnName, Double defaultValue) {
        ArrayList<Double> column = new ArrayList<Double>(this.capacity);
        for (int i = 0; i < this.nRow(); ++i) {
            column.add(defaultValue);
        }
        this.dataFrame.put(columnName, column);
        this.defaultValues.put(columnName, defaultValue);
        this.columnNames.add(columnName);
        this.columnTypes.add("Double");
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    public String getColumnType(int index) {
        return this.columnTypes.get(index);
    }

    public String getColumnType(String name) {
        int index = this.columnNames.indexOf(name);
        return this.columnTypes.get(index);
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.toArray(String[]::new);
    }

    public String[] getColumnTypes() {
        return (String[])this.columnTypes.toArray(String[]::new);
    }

    public ArrayList<Object> get(String columnName) {
        return this.dataFrame.get(columnName);
    }

    public String[] getStringColumn(String columnName) {
        return (String[])this.dataFrame.get(columnName).toArray(String[]::new);
    }

    public int[] getIntegerColumn(String columnName) {
        return this.dataFrame.get(columnName).stream().mapToInt(i -> (Integer)i).toArray();
    }

    public long[] getLongColumn(String columnName) {
        return this.dataFrame.get(columnName).stream().mapToLong(i -> (Long)i).toArray();
    }

    public double[] getDoubleColumn(String columnName) {
        return this.dataFrame.get(columnName).stream().mapToDouble(d -> (Double)d).toArray();
    }

    public boolean[] getBooleanColumn(String columnName) {
        ArrayList<Object> columnContents = this.dataFrame.get(columnName);
        int size = columnContents.size();
        boolean[] v = new boolean[size];
        for (int i = 0; i < size; ++i) {
            v[i] = (Boolean)columnContents.get(i);
        }
        return v;
    }

    public void clear() {
        this.columnNames.forEach(key -> {
            ArrayList<Object> column = this.dataFrame.get(key);
            column.clear();
        });
        this.rowCount = 0;
    }

    public void saveToCsv(String filename) throws FileNotFoundException {
        File csvOutputFile = new File(filename);
        try (PrintWriter pw = new PrintWriter(csvOutputFile);){
            StringJoiner row = new StringJoiner(",");
            this.columnNames.forEach(row::add);
            pw.println(row);
            for (int i = 0; i < this.nRow(); ++i) {
                row = new StringJoiner(",");
                for (String c : this.columnNames) {
                    row.add(String.valueOf(this.dataFrame.get(c).get(i)));
                }
                pw.println(row);
            }
        }
    }
}

