% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/amBoxplot.R
\name{amBoxplot}
\alias{amBoxplot}
\alias{amBoxplot.data.frame}
\alias{amBoxplot.default}
\alias{amBoxplot.formula}
\alias{amBoxplot.matrix}
\title{Plotting boxplot using rAmCharts}
\usage{
amBoxplot(object, ...)

\method{amBoxplot}{default}(object, main = NULL, xlab = NULL, ylab = NULL,
  ylim = NULL, names = NULL, col = NULL, horizontal = FALSE, ...)

\method{amBoxplot}{data.frame}(object, main = NULL, id = NULL,
  xlab = NULL, ylab = NULL, ylim = NULL, col = NULL,
  horizontal = FALSE, ...)

\method{amBoxplot}{matrix}(object, use.cols = TRUE, main = NULL,
  xlab = NULL, ylab = NULL, ylim = NULL, col = NULL,
  horizontal = FALSE, ...)

\method{amBoxplot}{formula}(object, data = NULL, id = NULL, main = NULL,
  xlab = NULL, ylab = NULL, ylim = NULL, col = NULL,
  horizontal = FALSE, ...)
}
\arguments{
\item{object}{a vector, data.frame, a matrix, or a formula !}

\item{...}{Don't use... For S3 Definition...}

\item{main}{\code{character}, title of the graph.}

\item{xlab,ylab}{\code{character}, labels of the axis.}

\item{ylim}{the range of y values with sensible defaults.}

\item{names}{in case of vector, name on x-axis}

\item{col}{color(s) to be used to fill the boxplot}

\item{horizontal}{Boolean. Rotate boxplot ?}

\item{id}{in case of using a data.frame, column name of id for identify outliers}

\item{use.cols}{for matrix only. Boxplot on columns or rows ?}

\item{data}{a data.frame from which the variables in formula should be taken}
}
\description{
amBoxplot computes a boxplot of the given data values.
Can be a vector, a data.frame, or a matrix
}
\examples{
# formula
(obj <- amBoxplot(count ~ spray, data = InsectSprays))
print(obj)

# adding parameters
amBoxplot(count ~ spray, data = InsectSprays, ylim = c(0,50),
 main = "Boxplot", xlab = "spray", col = c("darkblue", "gray"))

# transpose
amBoxplot(count ~ spray, data = InsectSprays, ylim = c(0,50),
 main = "Boxplot", xlab = "spray", horizontal = TRUE)

# using a custom colum to identify outliers
InsectSprays$id <- paste0("ID : ", 1:nrow(InsectSprays))
amBoxplot(count ~ spray, data = InsectSprays, id = "id")

# data.frame
don <- data.frame(a = 1:10, b = 1:5)
amBoxplot(don, ylim = c(0,15))

# matrix
x = matrix(nrow = 10, ncol = 5, rnorm(50))

amBoxplot(x) # on columns
colnames(x) <- LETTERS[1:5]
amBoxplot(x) # with names
amBoxplot(x, use.cols = FALSE, col = c("blue", "red"))

# vector
amBoxplot(rnorm(100))
}

