\name{synthetic_stream}
\alias{synthetic_stream}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Create a Synthetic Data Stream}
\description{
This function creates a synthetic data stream 
with data points in roughly \eqn{[0, 1]^p} by choosing
points form k clusters following a sequence 
through these clusters. Each cluster has a density function following a 
d-dimensional normal distributions. In the test set outliers are introduced.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
synthetic_stream(k = 10, d = 2, n_subseq = 100, p_transition = 0.5, p_swap = 0,
n_train = 5000, n_test = 1000, p_outlier = 0.01, rangeVar = c(0, 0.005))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{k}{number of clusters.}
  \item{d}{dimensionality of data set.}
  \item{n_subseq}{length of subsequence which will be repeat to create the data set.}
  \item{p_transition}{probability that the next position in the subsequence will belong to a different cluster.}
  \item{p_swap}{probability that two data points are swapped. This represents
  measurement errors (e.g., a data points arrive out of order) or that
  the data stream does not exactly follow the subsequence.}
  \item{n_train}{size of training set (without outliers).}
  \item{n_test}{size of test set (with outliers).}
  \item{p_outlier}{probability that a data point is replaced by an outlier
  (a randomly chosen point in \eqn{[0,1]^p}).}
  \item{rangeVar}{Used to create the random covariance matrices for the 
  clusters. See \code{genPositiveDefMat()} in \pkg{clusterGeneration}
  for details.}
}
\details{
The data generation process creates a data set consisting of \code{k} 
clusters in
roughly \eqn{[0,1]^d}.  The data points for each cluster are be drawn from a
multivariate normal distribution given a random mean and a random
variance/covariance matrix for each cluster. The temporal aspect is modeled by
a fixed subsequence (of length \code{n\_subseq}) through the k 
clusters. In each step in the subsequence we
have a transition probability \code{p\_transition} that the next data point 
is in the same
cluster or in a randomly chosen other cluster, thus we can create slowly or
fast changing data.  For the complete sequence, the subsequence is repeated
to create \code{n_test}/\code{n_train} data points. 
The data set is generated by drawing a data point from
the cluster corresponding to each position in the sequence. Outliers are
introduced by replacing data points in the data set with probability
\code{$p_outlier} by
randomly chosen data points in \eqn{[0,1]^d}.  
Finally, to introduce imperfection
in the temporal sequence (e.g., because the data does not follow exactly a
repeating sequence or because observations do not arrive in the correct order),
we swap two consecutive observations with probability \code{p_swap}. 
}
\value{
A list with the following elements:
\item{test}{ test data.}
\item{train}{ training data.}
\item{sequence\_test}{ sequence of the test data points through the clusters.}
\item{sequence\_train}{sequence of the training data points through the clusters.}
\item{swap\_test}{index where points are swapped.}
\item{swap\_train}{index where points are swapped.}
\item{outlier_position}{ logical vector for outliers in test data.}
\item{model}{ centers and covariance matrices for the clusters. }
}
%\references{
%% ~put references to the literature/web site here ~
%}
%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
## create only test data (with outliers)
ds <- synthetic_stream(n_train=0)

## plot test data
plot(ds$test, pch = ds$sequence_test, col ="gray")
text(ds$model$mu[,1], ds$model$mu[,2], 1:10)

## mark outliers
points(ds$test[ds$outlier_position,], pch=3, lwd=2, col="red")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{datagen}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
