% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.plot.trajectory.R
\name{ena.plot.trajectory}
\alias{ena.plot.trajectory}
\title{Plot of ENA trajectories}
\usage{
ena.plot.trajectory(enaplot, points, by = NULL, labels = NULL,
  labels.show = c("Always", "Hover", "Both"), names = NULL,
  label.offset = NULL, label.font.size = enaplot$get("font.size"),
  label.font.color = enaplot$get("font.color"),
  label.font.family = c("Arial", "Courier New", "Times New Roman"),
  shape = c("circle", "square", "triangle-up", "diamond"),
  colors = NULL, default.hidden = F)
}
\arguments{
\item{enaplot}{\code{\link{ENAplot}} object to use for plotting}

\item{points}{dataframe of matrix - first two column are X and Y coordinates, each row is a point in a trajectory}

\item{by}{vector used to subset points into individual trajectories, length nrow(points)}

\item{labels}{character vector - point labels, length nrow(points)}

\item{labels.show}{A character choice: Always, Hover, Both.  Default: Both}

\item{names}{character vector - labels for each trajectory of points, length length(unique(by))}

\item{label.offset}{A numeric vector of an x and y value to offset labels from the coordinates of the points}

\item{label.font.size}{An integer which determines the font size for labels, default: enaplot\$font.size}

\item{label.font.color}{A character which determines the color of label font, default: enaplot\$font.color}

\item{label.font.family}{A character which determines font type, choices: Arial, Courier New, Times New Roman, default: enaplot\$font.family}

\item{shape}{A character which determines the shape of markers, choices: square, triangle, diamond, circle, default: circle}

\item{colors}{A character vector, that determines marker color, default NULL results in
alternating random colors. If single color is supplied, it will be used for all
trajectories, otherwise the length of the supplied color vector should be equal
to the length of the supplied names (i.e a color for each trajectory being plotted)}

\item{default.hidden}{A logical indicating if the trajectories should start hidden (click on the legend to show them) Default: FALSE}
}
\value{
The \code{\link{ENAplot}} provided to the function, with its plot updated to include the trajectories
}
\description{
Function used to plot trajectories
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("GroupName","ActivityNumber")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post","C.Change")],
  codes = RS.data[,codeNames],
  window.size.back = 4,
  model = "A"
);

set = ena.make.set(accum);

unitNames = set$enadata$units

### Subset rotated points and plot Condition 1 Group Mean
first.game = unitNames$Condition == "FirstGame"
first.game.points = set$points.rotated[first.game,]

### Subset rotated points and plot Condition 2 Group Mean
second.game = unitNames$Condition == "SecondGame"
second.game.points = set$points.rotated[second.game,]

### get mean network plots
first.game.lineweights = set$line.weights[first.game,]
first.game.mean = colMeans(first.game.lineweights)

second.game.lineweights = set$line.weights[second.game,]
second.game.mean = colMeans(second.game.lineweights)

subtracted.network = first.game.mean - second.game.mean

# Plot dimension 1 against ActivityNumber metadata
dim.by.activity = cbind(
    set$points.rotated[,1],
    set$enadata$trajectories$step$ActivityNumber*.8/14-.4  #scale down to dimension 1
)

plot = ena.plot(set)
plot = ena.plot.network(plot, network = subtracted.network, legend.name="Network")
plot = ena.plot.trajectory(
  plot,
  points = dim.by.activity,
  names = unique(set$enadata$units$UserName),
  by = set$enadata$units$UserName
);
print(plot)

}
\seealso{
\code{\link{ena.plot}}
}
\keyword{ENA,}
\keyword{plot,}
\keyword{trajectory}
