% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.plot.R
\name{ena.plot}
\alias{ena.plot}
\title{Generate a plot of an ENAset}
\usage{
ena.plot(
  enaset,
  title = "ENA Plot",
  dimension.labels = c("", ""),
  font.size = 10,
  font.color = "#000000",
  font.family = c("Arial", "Courier New", "Times New Roman"),
  scale.to = "network",
  ...
)
}
\arguments{
\item{enaset}{The \code{\link{ENAset}} that will be used to generate a plot}

\item{title}{A character used for the title of the plot, default: ENA Plot}

\item{dimension.labels}{A character vector containing labels for the axes, default: c(X, Y)}

\item{font.size}{An integer determining the font size for graph labels, default: 10}

\item{font.color}{A character determining the color of label font, default: black}

\item{font.family}{A character determining the font type, choices: Arial, Courier New, Times New Roman, default: Arial}

\item{scale.to}{"network" (default), "points", or a list with x and y ranges. Network and points both scale to the c(-max, max) of the corresponding data.frame}

\item{...}{additional parameters addressed in inner function}
}
\value{
\code{\link{ENAplot}} used for plotting an ENAset
}
\description{
Generates an a plot from a given ENA set object
}
\details{
This function defines the axes and other features of a plot for displaying an ENAset; generates an ENAplot object that can used to plot points, network graphs, and other information from an ENAset
}
\examples{
data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum
)

plot = ena.plot(set)

group1.points = set$points.rotated[set$enadata$units$Condition == "FirstGame",]
plot = ena.plot.points(plot, points = group1.points);
print(plot);

}
\seealso{
\code{\link{ena.make.set}}, \code{\link{ena.plot.points}}
}
