% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSA.R
\name{FSA}
\alias{FSA}
\alias{lmFSA}
\alias{glmFSA}
\title{FSA: Feasible Solution Algorithm}
\usage{
FSA(formula, data, fitfunc = lm, fixvar = NULL, quad = FALSE, m = 2,
  numrs = 1, cores = 1, interactions = T, criterion = AIC,
  minmax = "min", checkfeas = NULL, var4int = NULL, min.nonmissing = 1,
  return.models = FALSE, ...)

lmFSA(...)

glmFSA(...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{a data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model.}

\item{fitfunc}{the method that should be used to fit the model. For Example: lm, glm, or other methods that rely on formula, data, and other inputs.}

\item{fixvar}{variable(s) to fix in the model. Usually a covariate that should always be included (Example: Age, Sex). Will still consider it with interactions. Default is NULL.}

\item{quad}{Include quadratic terms or not. Logical.}

\item{m}{order of terms to include. If interactions is set to TRUE then m is the order of interactions to be considered. For Subset selection (interaction=F), m is the size of the subset to examine. Defaults to 2.}

\item{numrs}{number of random starts to perform.}

\item{cores}{number of cores to use while running. Note: Windows can only use 1 core. See mclapply for details. If function detects a Windows user it will automatically set cores=1.}

\item{interactions}{whether to include interactions in model. Defaults to TRUE.}

\item{criterion}{which criterion function to either maximize or minimize. For linear models one can use: r.squared, adj.r.squared, cv5.lmFSA (5 Fold Cross Validation error), cv10.lmFSA (10 Fold Cross Validation error), apress (Allen's Press Statistic), int.p.val (Interaction P-value), AIC, BIC.}

\item{minmax}{whether to minimize or maximize the criterion function}

\item{checkfeas}{vector of variables that could be a feasible solution. These variables will be used as the last random start.}

\item{var4int}{specification of which variables to check for marginal feasiblilty. Default is NULL}

\item{min.nonmissing}{the combination of predictors will be ignored unless this many of observations are not missing}

\item{return.models}{bool value to specify whether return all the fitted models which have been checked}

\item{...}{other arguments passed to fitfunc.}
}
\value{
matrix of results
}
\description{
A function using a Feasible Solution Algorithm to find a set of feasible solutions for a statistical model of a specific form that could include mth-order interactions (Note that these solutions are optimal in the sense that no one swap to any of the variables will increase the criterion function.)
}
\section{Functions}{
\itemize{
\item \code{FSA}: find best set of variables for statistical models

\item \code{lmFSA}: alias for \code{FSA(fitfunc=lm,...)}

\item \code{glmFSA}: alias for \code{FSA(fitfunc=glm,...)}
}}

\examples{

N <- 10 #number of obs
P <- 100 #number of variables
data <- data.frame(matrix(rnorm(N*(P+1)), nrow = N, ncol = P+1))

sln <- FSA(formula = "X101~1", data = data, cores = 1, m = 2,
interactions = FALSE, criterion = AIC, minmax = "min",
numrs = 10)
sln

}
