% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLevel2BPAVDProfile.R
\name{getLevel2BPAVDProfile}
\alias{getLevel2BPAVDProfile}
\title{Get GEDI Plant Area Volume Density (PAVD) Index Profile (GEDI Level2B)}
\usage{
getLevel2BPAVDProfile(level2b)
}
\arguments{
\item{level2b}{A GEDI Level2B object (output of \code{\link[rGEDI:readLevel2B]{readLevel2B}} function).
An S4 object of class "gedi.level2b".}
}
\value{
Returns an S4 object of class \code{\link[data.table:data.table]{data.table-class}}
containing the Plant Area Volume Density Index.
}
\description{
This function extracts the Plant Area Volume Density (PAVD) Profile from GEDI Level2B data.
}
\details{
Characteristics. Flag indicating likely invalid waveform (1=valid, 0=invalid).
\itemize{
\item \emph{beam} Beam identifie
\item \emph{shot_number} Shot number
\item \emph{algorithmrun_flag} The L2B algorithm is run if this flag is set to 1 indicating data have sufficient waveform fidelity for L2B to run
\item \emph{l2b_quality_flag} L2B quality flag
\item \emph{delta_time} Transmit time of the shot since Jan 1 00:00 2018
\item \emph{lat_lowestmode} Latitude of center of lowest mode
\item \emph{lon_lowestmode} Longitude of center of lowest mode
\item \emph{elev_highestreturn} Elevation of highest detected return relative to reference ellipsoid
\item \emph{elev_lowestmode} Elevation of center of lowest mode relative to reference ellipsoid
\item \emph{height_lastbin} Height of the last bin of the pgap_theta_z, relative to the ground
\item \emph{pavd_z} Plant Area Volume Density profile
}
}
\examples{
# Specifying the path to GEDI level2B data (zip file)
outdir = tempdir()
level2B_fp_zip <- system.file("extdata",
                  "GEDI02_B_2019108080338_O01964_T05337_02_001_01_sub.zip",
                  package="rGEDI")

# Unzipping GEDI level2A data
level2Bpath <- unzip(level2B_fp_zip,exdir = outdir)

# Reading GEDI level2B data (h5 file)
level2b<-readLevel2B(level2Bpath=level2Bpath)

# Extracting GEDI Plant Area Volume Density (PAVD) Index
level2BPAVDProfile<-getLevel2BPAVDProfile(level2b)
head(level2BPAVDProfile)

close(level2b)
}
\seealso{
https://lpdaac.usgs.gov/products/gedi02_bv001/
}
