% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.similarity.R
\name{msc.similarity}
\alias{msc.similarity}
\title{Minicircle Sequence Cluster similarity}
\usage{
msc.similarity(clustmatrices, samples, groups)
}
\arguments{
\item{clustmatrices}{a list of cluster matrices.}

\item{samples}{a vector containing the names of the samples. This can include all samples or it can be a subset.}

\item{groups}{a vector, of equal length as samples,  specifying to which group (e.g. species) the samples belong to.}
}
\value{
\item{absfreq}{a list per percent identity containing absolute frequency values of shared and unique MSCs.}
\item{absfreq.plot}{a list of barplots visualizing previous results.}
\item{relfreq}{a list per percent identity containing relative frequency values of shared and unique MSCs.}
\item{relfreq.plot}{one barplot visualizing previous results.}
}
\description{
The msc.similarity function allows you to check the absolute and relative frequency of shared and unique MSC between different groups across different percent identities.
}
\examples{
require(viridis)
data(matrices)
data(exData)

### run function
sim <- msc.similarity(matrices, samples = exData$samples, 
                      groups = exData$species)

### visualize results (absolute frequencies)
barplot(sim$absfreq$id93)

### adjust plot (relative frequencies)
sim$relfreq.plot + scale_fill_viridis(discrete = TRUE)

sim$relfreq$id97["2"]*100 
sim$relfreq$id97["3"]*100 

### reduce number of groups 
groups <- exData$species
levels(groups)[levels(groups)!='hybrid'] <- "non-hybrid"
sim.red <- msc.similarity(matrices, samples = exData$samples, groups = groups)
sim.red$relfreq.plot + scale_fill_viridis(discrete = TRUE)

}
