% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.heatmap.R
\name{msc.heatmap}
\alias{msc.heatmap}
\title{Visualization of cluster matrices}
\usage{
msc.heatmap(clustmatrix, samples, groups)
}
\arguments{
\item{clustmatrix}{a cluster matrix generated with the msc.matrix function. This matrix represents the presence or absence of MCSs in each sample.}

\item{samples}{a vector containing the sample names.}

\item{groups}{a vector specifying the groups (e.g., species) to which the samples belong.}
}
\value{
a heatmap that visualizes the clustering patterns of MCSs between sample groups. The heatmap provides an overview of the presence or absence of MCSs and helps identify shared or distinct MCS patterns among the groups.
}
\description{
The msc.heatmap function generates a heatmap that summarizes the presence or absence of Minicircle Sequence Classes (MCSs) between groups of samples. It takes an input cluster matrix, generated using the msc.matrix function, and visualizes the clustering patterns of MCSs.
}
\examples{
data(exData)
data(matrices)

### run function 
msc.heatmap(matrices[["id80"]], groups = exData$species,
            samples = exData$samples )
   
### run function on every cluster matrix with subset of samples
### you will be asked to confirm
table(exData$species)
hybrid <- which(exData$species=="hybrid")
# msc.heatmap(matrices[["id97"]], groups = exData$species[hybrid], 
#             samples = exData$samples[hybrid])


}
