% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_graphics.R
\name{MEAdistplot}
\alias{MEAdistplot}
\title{Distribution of cross-correlations}
\usage{
MEAdistplot(mea, contrast = F, by.group = T, ...)
}
\arguments{
\item{mea}{a well formatted list of \code{MEA} objects (see function \code{\link{MEAlist}}).}

\item{contrast}{either FALSE or a list of \code{MEA} objects to be used as a contrast}

\item{by.group}{logical. Should the different groups of \code{mea} be plotted separately?}

\item{...}{further graphical parameters passed to  \code{\link[graphics]{plot}}}
}
\description{
Plots the distribution of the average cross-correlations in a list of \code{MEA} objects.
}
\details{
If \code{contrast} is defined, then a normalized difference (Cohen's \emph{d}) between the means of each group and the contrast is provided.
Otherwise, if the \code{mea} object has 3 or less groups, Cohen's \emph{d} will be calculated on the group differences.
}
\examples{
\donttest{
## This example is excluded from test as it may take more than 10s to run
## read the first 4 minutes of the normal sample
##   (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_normal <- setGroup(mea_normal, "normal")

## read the dropout sample (intake interviews of patients that dropped out)
path_dropout <- system.file("extdata/dropout", package = "rMEA")
mea_dropout <- readMEA(path_dropout, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_dropout <- setGroup(mea_dropout, "dropout")

## Combine into a single object
mea_all = c(mea_normal, mea_dropout)

## Create a shuffled sample
mea_rand = shuffle(mea_all, 20)

## Compute ccf
mea_all = MEAccf(mea_all, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = TRUE)
mea_rand = MEAccf(mea_rand, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = TRUE)

## Visualize the effects:

MEAdistplot(mea_all, contrast = mea_rand, by.group = TRUE)
}
}
