% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_graphics.R
\name{MEAlagplot}
\alias{MEAlagplot}
\title{Plots the average cross-correlation at different lags}
\usage{
MEAlagplot(mea, contrast = F, by.group = T, ...)
}
\arguments{
\item{mea}{a list of \code{MEA} objects (see function \code{\link{MEAlist}}).}

\item{contrast}{either FALSE or a list of \code{MEA} objects to be used as a contrast}

\item{by.group}{logical. Should the different groups of \code{mea} be plotted separately?}

\item{...}{further arguments and \code{\link[graphics]{par}} parameters passed to \code{\link[graphics]{plot}}}
}
\description{
Provides a graphical representation of the comparison between two lists of \code{MEA} objects.
The X-axis represents the lag values over which cross-correlation was calculated (in seconds), the Y-axis represents the averaged strength of the cross-correlation.
Typically, the  is useful for a visual inspection of the strength of synchrony from real dyads in relation to synchrony expected by coincidence (pseudosynchrony).
}
\details{
A typical application of \code{MEAlagplot} is to represent the difference between real dyads and random dyads obtained through a \code{\link{shuffle}} procedure.
It may also be used to see the difference among various filtering procedures or different regions of interest (e.g. head-synchrony versus body-synchrony, female vs. male dyads, etc).

Percentages indicate the relative amount of synchrony where the values are higher than the contrast sample.
}
\examples{
\donttest{
## This example is excluded from test as it takes more than 10s to run
## read the first 4 minutes of the normal sample
##   (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_normal <- setGroup(mea_normal, "normal")

## read the dropout sample (intake interviews of patients that dropped out)
path_dropout <- system.file("extdata/dropout", package = "rMEA")
mea_dropout <- readMEA(path_dropout, sampRate = 25, s1Col = 1, s2Col = 2,
                     s1Name = "Patient", s2Name = "Therapist",
                     idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_dropout <- setGroup(mea_dropout, "dropout")

## Combine into a single object
mea_all = c(mea_normal, mea_dropout)

## Create a shuffled sample
mea_rand = shuffle(mea_all, 20)

## Compute ccf
mea_all = MEAccf(mea_all, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = TRUE)
mea_rand = MEAccf(mea_rand, lagSec = 5, winSec = 60, incSec = 30, r2Z = TRUE, ABS = TRUE)

## Visualize the effects:

MEAlagplot(mea_all, contrast = mea_rand, by.group = TRUE)
}
}
