% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_processing.R
\name{add_bin_labels}
\alias{add_bin_labels}
\title{Reverse numeric conversion of binary vector}
\usage{
add_bin_labels(x, one, zero, fast = TRUE)
}
\arguments{
\item{x}{A numeric vector or column, scaled between 0 and 1}

\item{one}{A character string, the label associated with binary value 1}

\item{zero}{A character string, the label associated with binary value 0}

\item{fast}{Boolean indicating whether to return binary value 1 if predicted probability >= 0.5  (TRUE), or take random draw using predicted probability as weighting.}
}
\value{
Vector of character strings corresponding to binary values
}
\description{
Helper function to re-apply binary variable labels post-imputation.
}
\examples{
ex_bin <- c(1,0,0,1,1,0,0,1,0)
cat <- "cat"
dog <- "dog"

add_bin_labels(x = ex_bin, one = cat, zero = dog)
}
\keyword{postprocessing}
