% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Data.r
\name{MVP.Data.Numeric2MVP}
\alias{MVP.Data.Numeric2MVP}
\title{MVP.Data.Numeric2MVP: To transform Numeric data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018}
\usage{
MVP.Data.Numeric2MVP(num_file, map_file, out = "mvp", maxLine = 10000,
  priority = "speed", row_names = FALSE, col_names = FALSE,
  type.geno = "char", auto_transpose = TRUE, verbose = TRUE)
}
\arguments{
\item{num_file}{Genotype in Numeric format (0,1,2)}

\item{map_file}{Genotype map file, SNP_name, Chr, Pos}

\item{out}{the name of output file}

\item{maxLine}{the max number of line to write to big matrix for each loop}

\item{priority}{'memory' or 'speed'}

\item{row_names}{whether the numeric genotype has row names}

\item{col_names}{whether the numeric genotype has column names}

\item{type.geno}{the type of genotype elements}

\item{auto_transpose}{whether to detecte the row and column}

\item{verbose}{whether to print the reminder}
}
\value{
number of individuals and markers.
Output files:
genotype.desc, genotype.bin: genotype file in bigmemory format
phenotype.phe: ordered phenotype file, same taxa order with genotype file
map.map: SNP information
}
\description{
MVP.Data.Numeric2MVP: To transform Numeric data to MVP package
Author: Haohao Zhang
Build date: Sep 12, 2018
}
\examples{
numericPath <- system.file("extdata", "04_numeric", "mvp.num", package = "rMVP")
mapPath <- system.file("extdata", "04_numeric", "mvp.map", package = "rMVP")
MVP.Data.Numeric2MVP(numericPath, mapPath, tempfile("outfile"))

}
