% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.K.VanRaden.r
\name{MVP.K.VanRaden}
\alias{MVP.K.VanRaden}
\title{Calculate Kinship matrix by VanRaden method}
\usage{
MVP.K.VanRaden(
  M,
  maxLine = 5000,
  ind_idx = NULL,
  cpu = 1,
  verbose = TRUE,
  checkNA = TRUE
)
}
\arguments{
\item{M}{Genotype, m * n, m is marker size, n is population size}

\item{maxLine}{the number of markers handled at a time, smaller value would reduce the memory cost}

\item{ind_idx}{the index of effective genotyped individuals used in analysis}

\item{cpu}{the number of cpu}

\item{verbose}{whether to print detail.}

\item{checkNA}{whether to check NA in genotype.}
}
\value{
K, n * n matrix
}
\description{
Build date: Dec 12, 2016
Last update: Dec 12, 2019
}
\examples{
\donttest{
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

K <- MVP.K.VanRaden(genotype, cpu=1)
}

}
