% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{pt.interpolate}
\alias{pt.interpolate}
\title{pt.interpolate}
\usage{
pt.interpolate(pt, t)
}
\arguments{
\item{pt}{PitchTier object}

\item{t}{vector of time instances of interest}
}
\value{
PitchTier object
}
\description{
Interpolates PitchTier contour in given time instances.
}
\details{
a) If t < min(pt$t) (or t > max(pt$t)), returns the first (or the last) value of pt$f.
 b) If t is existing point in pt$t, returns the respective pt$f.
 c) If t is Between two existing points, returns linear interpolation of these two points.
}
\examples{
pt <- pt.sample()
pt <- pt.Hz2ST(pt, ref = 100)  # conversion of Hz to Semitones, reference 0 ST = 100 Hz.
pt2 <- pt.interpolate(pt, seq(pt$t[1], pt$t[length(pt$t)], by = 0.001))
\dontrun{
pt.plot(pt)
pt.plot(pt2)
}
}
\seealso{
\code{\link{pt.read}}, \code{\link{pt.write}}, \code{\link{pt.plot}}, \code{\link{pt.Hz2ST}}, \code{\link{pt.cut}}, \code{\link{pt.cut0}}, \code{\link{pt.legendre}}
}
