% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snd.R
\name{snd.plot}
\alias{snd.plot}
\title{snd.plot}
\usage{
snd.plot(snd, group = "", stemPlot = FALSE)
}
\arguments{
\item{snd}{Sound object (with \code{$sig} and \code{$fs} members at least)}

\item{group}{[optional] character string, name of group for dygraphs synchronization}

\item{stemPlot}{[optional] discrete style of plot using}
}
\description{
Plots interactive Sound object using dygraphs package. If the sound is 2-channel (stereo), the 1st channel is plotted around mean value +1, the 2nd around mean value -1.
}
\examples{
\dontrun{
snd <- snd.sample()
snd.plot(snd)

snd.plot(list(sig = sin(seq(0, 2*pi, length.out = 4000)), fs = 8000))
}
}
\seealso{
\code{\link{snd.read}}
}
