% Generated by roxygen2 (4.0.1): do not edit by hand
\name{base_pref_macros}
\alias{around}
\alias{base_pref_macros}
\alias{between}
\alias{layered}
\alias{pos}
\title{Useful base preference macros}
\usage{
around(expr, center)

between(expr, left, right)

pos(expr, pos_value)

layered(expr, ...)
}
\arguments{
\item{expr}{The value which should be in the preferred interval, layer, etc. The same requirements as for \code{\link{base_pref}} apply.}

\item{center}{Preferred value, where a values from the given \code{expr} should be near by.}

\item{left}{Lower limit for a preferred interval.}

\item{right}{Upper limit for a preferred interval.}

\item{pos_value}{The preferred value or set for a pos-preference.}

\item{...}{Layers (sets) for a layered-Preference, where the first set are the most preferred values.}
}
\description{
In addition to the fundamental base preferences, rPref offers some macros to define preferences where a given interval or point is preferred.
}
\section{Definition of the preference macros}{


\describe{
  \item{\code{between(expr, left, right)}}{Those tuples are preferred, where \code{expr} evaluates to a value between l and r.
  For values not in this interval, the values nearest to [l, r] are preferred.}
  \item{\code{around(expr, center)}}{Same as \code{between(expr, center, center)}.}
  \item{\code{pos(expr, pos_value)}}{If \code{expr} evaluates to a value which is contained in \code{pos_value}, these tuples are preferred.}
  \item{\code{layered(expr, layer1, layer2, ..., layerN)}}{For the most preferred tuples, \code{expr} must evaluate to a value in \code{layer1}.
  The second-best tuples are those, where \code{expr} evaluates to a value in \code{layer2}, and so forth.
  Values occuring in non of the layers are considered worse than those in \code{layerN}.
  Technically, this is realized by a Prioritization (lexicographical order) chain of boolean preferences.}
}
}
\examples{
# Search for cars where mpg is near to 25
psel(mtcars, around(mpg, 25))

# cyl = 2 and cyl = 4 are equally good, cyl = 6 is worse
psel(mtcars, layered(cyl, c(2, 4), 6))
}

