% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trading_md}
\alias{trading_md}
\title{Market Data Real Time}
\usage{
trading_md(
  connection,
  symbol,
  entries = c("BI", "OF", "LA", "OP", "CL", "SE", "OI", "HI", "LO", "TV", "IV", "EV",
    "NV", "TC"),
  depth = 1L,
  market_id = "ROFX",
  tidy = TRUE
)
}
\arguments{
\item{connection}{S4. \strong{Mandatory}. Formal rRofexConnection class object}

\item{symbol}{String. \strong{Mandatory}. Use \code{\link{trading_instruments}} to see which symbols are available.}

\item{entries}{Vector of Strings. When nothing is set, then \strong{all entries are the default}. It contains the information to be queried:
\itemize{
\item \strong{BI} - Bid.
\item \strong{OF} - Offer.
\item \strong{LA} - Last Available Price.
\item \strong{OP} - Open Price.
\item \strong{CL} - Close Price.
\item \strong{SE} - Settlement Price.
\item \strong{OI} - Open Interest.
\item \strong{HI} - Trading Session High Price
\item \strong{LO} - Trading Session Low Price
\item \strong{TV} - Trading Volume
\item \strong{IV} - Index Value
\item \strong{EV} - Trading Effective Volume
\item \strong{NV} - Nominal Volume
\item \strong{TC} - Trade Count
}}

\item{depth}{Integer. Depth of the book. Default is \strong{1L}.}

\item{market_id}{String. Market to which you are going to connect. Default is \strong{ROFX}.
\itemize{
\item \strong{ROFX} - Matba Rofex
}}

\item{tidy}{Logical. Data arranged on a tidy format. Default is \strong{TRUE}.}
}
\value{
If correct, it will load a tibble data frame
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("stable")}
This method brings Market Data in Real Time.
}
\examples{

# If you want to query many products at once,
# I recommend you to use "purrr::map" family like this:

\dontrun{
purrr::map_df(
list('MERV - XMEV - GGAL - 48hs','MERV - XMEV - BYMA - 48hs'),
~trading_md(connection = conn, symbol = .x, entries = c("LA","OP", "NV"), tidy = T)
)
}
}
\seealso{
Other market data functions: 
\code{\link{trading_currencies}()},
\code{\link{trading_mdh}()}
}
\concept{market data functions}
