% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trading_instruments}
\alias{trading_instruments}
\title{List of Instruments}
\usage{
trading_instruments(
  connection,
  request,
  sec_detailed = FALSE,
  market_id = "ROFX",
  segment_id,
  cfi_code,
  sec_type
)
}
\arguments{
\item{connection}{S4. \strong{Mandatory} Formal rRofexConnection class object}

\item{request}{String. \strong{Mandatory} The type of request that you are making:
\itemize{
\item \strong{segments}: List available market segments
\item \strong{securities}: List available instruments listed on Matba Rofex. \emph{Depends on 'sec_detailed'}.
\item \strong{by_segment}: List available instruments searching by market segment. \emph{Depends on 'market_id' and 'segment_id'}
\item \strong{by_cfi_code}: List available instruments searching by CFI Code. \emph{Depends on 'cfi_code'}
\item \strong{by_type}: List available instruments searching by Instrument Type. See section Instrument Types. \emph{Depends on 'sec_detailed' and 'sec_type'}.
}}

\item{sec_detailed}{Logical. Optional for request='securities'. Brings additional information like segment, price, minimal/maximal trading quantity, settlement date, etc.}

\item{market_id}{String. Needed for request='by_segment'. Market ID.
\itemize{
\item \strong{ROFX}: Matba Rofex
}}

\item{segment_id}{String. Needed for request='by_segment'. Market Segment ID.
\itemize{
\item \strong{DDF}: Financial Derivatives
\item \strong{DDA}: Agricultural Derivatives
\item \strong{DUAL}: Other Derivatives
\item \strong{MERV}: S&P Merval
}}

\item{cfi_code}{String. Needed for request='by_cfi_code'. CFI Code. See \url{https://www.quotemedia.com/apifeeds/cfi_code}}

\item{sec_type}{String. Needed for request='by_type'.
\itemize{
\item \strong{E}: Equities
\item \strong{D}: Debt
\item \strong{C}: Collective Investment Vehicles
\item \strong{R}: Entitlements (Rights)
\item \strong{O}: Listed Options
\item \strong{F}: Futures
\item \strong{T}: Referential Instruments
\item \strong{M}: Others
}}
}
\value{
If correct, it will load a tibble data frame
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("stable")}
Method to list segments and instruments currently available through the Trading API.
}
\seealso{
Other reference data functions: 
\code{\link{trading_instruments_fronts}()}
}
\concept{reference data functions}
