% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{rspde.matern.precision.integer.opt}
\alias{rspde.matern.precision.integer.opt}
\title{Optimized precision matrix of stationary Gaussian Matern random fields with integer
covariance exponent}
\usage{
rspde.matern.precision.integer.opt(
  kappa,
  nu,
  tau,
  d,
  fem_matrices,
  graph = NULL
)
}
\arguments{
\item{kappa}{Range parameter of the covariance function.}

\item{nu}{Shape parameter of the covariance function.}

\item{tau}{Scale parameter of the covariance function.}

\item{d}{The dimension of the domain}

\item{fem_matrices}{A list containing the FEM-related matrices. The list should contain elements C, G, G_2, G_3, etc.}

\item{graph}{The sparsity graph of the matrices. If NULL, only a vector
of the elements will be returned, if non-NULL, a sparse matrix will be returned.}
}
\value{
The precision matrix
}
\description{
\code{rspde.matern.precision.integer.opt} is used for computing the
optimized version of the precision matrix of stationary Gaussian random
fields on \eqn{R^d} with a Matern covariance function
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}(\kappa h)^\nu K_\nu(\kappa h),}
where \eqn{\alpha = \nu + d/2} is a natural number.
}
