% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.computations.R
\name{simulate.CBrSPDEobj2d}
\alias{simulate.CBrSPDEobj2d}
\title{Simulation of a fractional SPDE using the
covariance-based rational SPDE approximation}
\usage{
\method{simulate}{CBrSPDEobj2d}(
  object,
  nsim = 1,
  seed = NULL,
  nu = NULL,
  hx = NULL,
  hy = NULL,
  hxy = NULL,
  sigma = NULL,
  m = NULL,
  ...
)
}
\arguments{
\item{object}{The covariance-based rational SPDE approximation,
computed using \code{\link[=matern2d.operators]{matern2d.operators()}}}

\item{nsim}{The number of simulations.}

\item{seed}{An object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{nu}{If non-null, update the shape parameter of the
covariance function.}

\item{hx}{If non-null, update the hx parameter.}

\item{hy}{If non-null, update the hy parameter.}

\item{hxy}{If non-null, update the hxy parameter.}

\item{sigma}{If non-null, update the standard deviation of
the covariance function.}

\item{m}{If non-null, update the order of the rational
approximation, which needs to be a positive integer.}

\item{...}{Currently not used.}
}
\value{
A matrix with the \code{n} samples as columns.
}
\description{
The function samples a Gaussian random field based using the
covariance-based rational SPDE approximation.
}
\examples{
library(fmesher)
n_loc <- 2000
loc_2d_mesh <- matrix(runif(n_loc * 2), n_loc, 2)
mesh_2d <- fm_mesh_2d(loc = loc_2d_mesh, cutoff = 0.03, max.edge = c(0.1, 0.5))
op <- matern2d.operators(mesh = mesh_2d, sigma = 1, nu = 1, hx = 0.1, hy = 0.1, hxy = 0)
u <- simulate(op)
}
