% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{transform_parameters_anisotropic}
\alias{transform_parameters_anisotropic}
\title{Transform Anisotropic SPDE Model Parameters to Original Scale}
\usage{
transform_parameters_anisotropic(theta, nu_upper_bound = NULL)
}
\arguments{
\item{theta}{A numeric vector of length 4 or 5, containing the transformed parameters in this order:
\describe{
\item{lhx}{The logarithmic representation of hx.}
\item{lhy}{The logarithmic representation of hy.}
\item{logit_hxy}{The logit-transformed representation of hxy.}
\item{lsigma}{The logarithmic representation of sigma.}
\item{lnu (optional)}{The logarithmic representation of nu. If not provided, nu is not returned.}
}}

\item{nu_upper_bound}{(optional) A numeric value representing the upper bound for the smoothness parameter nu.
This is only used, and must be provided, if \code{lnu} is provided.}
}
\value{
A named list with the parameters in the original scale:
\describe{
\item{hx}{The original scale for hx (exponential of lhx).}
\item{hy}{The original scale for hy (exponential of lhy).}
\item{hxy}{The original scale for hxy (inverse logit transformation of logit_hxy).}
\item{sigma}{The original scale for sigma (exponential of lsigma).}
\item{nu (optional)}{The original scale for nu (using the forward_nu transformation). Only included if \code{lnu} is provided.}
}
}
\description{
This function takes a vector of transformed parameters and applies the appropriate
transformations to return them in the original scale for use in anisotropic SPDE models.
}
\examples{
# With lnu
theta <- c(log(0.1), log(0.2), log((0.3 + 1) / (1 - 0.3)), log(0.5), log(1))
nu_upper_bound <- 2
transform_parameters_anisotropic(theta, nu_upper_bound)

# Without lnu
theta <- c(log(0.1), log(0.2), log((0.3 + 1) / (1 - 0.3)), log(0.5))
transform_parameters_anisotropic(theta)
}
