% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_segment.R
\name{get_segment}
\alias{get_segment}
\title{Retrieve details about a specific segment}
\usage{
get_segment(stoken, id = NULL, request = NULL)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{character for id of the segment}

\item{request}{chr string, must be "starred", "leaderboard", "all_efforts", or NULL for segment details}
}
\value{
Data from an API request.
}
\description{
Retreive details about a specific segment
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.  The authenticated user must have an entry for a segment to return all efforts if \code{request = "all_efforts"}. For \code{request = "starred"}, set \code{id = NULL}.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

# get segment info
get_segment(stoken, id = '229781')

# get top ten leaderboard for the segment
get_segment(stoken, id = '229781', request = "leaderboard")

# get all efforts for the authenticated user on the segment
get_segment(stoken, id = '4483903', request = 'all_efforts')

# get the starred segments for the user
get_segment(stoken, request = 'starred') 
}
}
\seealso{
\code{\link{compile_segment}} for converting the \code{list} output to \code{data.frame}
}
\concept{token}
