/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PySystemState;

public class Options {
    public static boolean showJavaExceptions = false;
    public static boolean includeJavaStackInExceptions = false;
    public static boolean showPythonProxyExceptions = false;
    public static boolean respectJavaAccessibility = true;
    public static boolean importSite = true;
    public static int verbose = 1;
    public static boolean deprecatedKeywordMangling = false;
    public static String proxyDebugDirectory = null;
    public static boolean caseok = false;
    public static boolean Qnew = false;
    public static boolean unbuffered = false;
    public static int divisionWarning = 0;

    private Options() {
    }

    private static boolean getBooleanOption(String name, boolean defaultValue) {
        String prop = PySystemState.registry.getProperty("python." + name);
        if (prop == null) {
            return defaultValue;
        }
        return prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("yes");
    }

    private static String getStringOption(String name, String defaultValue) {
        String prop = PySystemState.registry.getProperty("python." + name);
        if (prop == null) {
            return defaultValue;
        }
        return prop;
    }

    public static void setFromRegistry() {
        showJavaExceptions = Options.getBooleanOption("options.showJavaExceptions", showJavaExceptions);
        includeJavaStackInExceptions = Options.getBooleanOption("options.includeJavaStackInExceptions", includeJavaStackInExceptions);
        showPythonProxyExceptions = Options.getBooleanOption("options.showPythonProxyExceptions", showPythonProxyExceptions);
        deprecatedKeywordMangling = Options.getBooleanOption("deprecated.keywordMangling", deprecatedKeywordMangling);
        respectJavaAccessibility = Options.getBooleanOption("security.respectJavaAccessibility", respectJavaAccessibility);
        proxyDebugDirectory = Options.getStringOption("options.proxyDebugDirectory", proxyDebugDirectory);
        String prop = PySystemState.registry.getProperty("python.verbose");
        if (prop != null) {
            if (prop.equalsIgnoreCase("error")) {
                verbose = -1;
            } else if (prop.equalsIgnoreCase("warning")) {
                verbose = 0;
            } else if (prop.equalsIgnoreCase("message")) {
                verbose = 1;
            } else if (prop.equalsIgnoreCase("comment")) {
                verbose = 2;
            } else if (prop.equalsIgnoreCase("debug")) {
                verbose = 3;
            } else {
                throw Py.ValueError("Illegal verbose option setting: '" + prop + "'");
            }
        }
        caseok = Options.getBooleanOption("options.caseok", caseok);
        Qnew = Options.getBooleanOption("options.Qnew", Qnew);
        prop = PySystemState.registry.getProperty("python.divisionWarning");
        if (prop != null) {
            if (prop.equalsIgnoreCase("old")) {
                divisionWarning = 0;
            } else if (prop.equalsIgnoreCase("warn")) {
                divisionWarning = 1;
            } else if (prop.equalsIgnoreCase("warnall")) {
                divisionWarning = 2;
            } else {
                throw Py.ValueError("Illegal divisionWarning option setting: '" + prop + "'");
            }
        }
    }
}

